﻿/*

	12/01/2023 Occhialini Lorenzo: Implementazione ALY-43736 (TFS N.171510) del 22/12/2022 - Task ALY-43738
	12/01/2022 Occhialini Lorenzo: Implementazione N.169404 del 04/01/2022 - Fase 169406
    19/02/2021 Occhialini Lorenzo: Implementazione N.157735 del 09/02/2021 - Fase 157762
    20/01/2021 Occhialini Lorenzo: Implementazione N.156281 del 21/12/2020 - Fase 156282
    
	----------------------------------------------------------------------------------------------------------------------------------------------------------------
    
	CGW0_WEBSERVER               - Server  TS DIGITAL Modello IVA (300 - 301 - 302 - 303 - 304 / 3aa (aa = anno a partire dal 2020)
	                                                               400 - 401 - 402 - 403 - 404 / 4aa (aa = anno a partire dal 2020))
    
	CGW1_WEBSERVICE              - Servizi TS DIGITAL Modello IVA (300 - Autenticazione
	                                                               301 - Autenticazione a scadenza
	                                                               302 - Company registry
																   303 - Verifica attivazione servizio
																   304 - Abilitazione servizio
																   320 - Modello IVA 2020
																   321 - Modello IVA 2021
																   322 - Modello IVA 2022
																   323 - Modello IVA 2023
																   3xx - ecc.)
	                                                              (400 - Autenticazione
	                                                               401 - Autenticazione a scadenza
	                                                               402 - Company registry
																   403 - Verifica attivazione servizio
																   404 - Abilitazione servizio
																   420 - Modello IVA 2020
																   421 - Modello IVA 2021
																   422 - Modello IVA 2022
																   423 - Modello IVA 2023
																   4xx - ecc.)

    ----------------------------------------------------------------------------------------------------------------------------------------------------------------

*/

SET NOCOUNT ON 
 
IF OBJECT_ID(N'tempdb..#CGW0', N'U') IS NOT NULL
  DROP TABLE #CGW0
;
IF OBJECT_ID(N'tempdb..#CGW1', N'U') IS NOT NULL
  DROP TABLE #CGW1
;

SELECT 
    CGW0_CODICE
  , CGW0_DESCRIZIONE
  , CGW0_FLGACCOUNTAZ
  , CGW0_IDSOFTWARE
  , CGW0_URL
  , CGW0_IDAZIENDA
  , CGW0_FLGPERS
  , CGW0_FLGFIRMATARIO
  , CGW0_INDMENUPARAM
  , CGW0_ORD 
  , CGW0_PROTOCOLLO
  , CGW0_PORTA
INTO #CGW0 
FROM CGW0_WEBSERVER WITH(NOLOCK)
WHERE 1 = 0
;
SELECT
    CGW1_CODICE
  , CGW1_CODICE_CGW0
  , CGW1_DESCRIZIONE
  , CGW1_DESCRTIPOWS
  , CGW1_URL
  , CGW1_FLGPERS
INTO #CGW1 
FROM CGW1_WEBSERVICE WITH(NOLOCK)
WHERE 1 = 0
;
DECLARE @CGW0_CDC   AS INT = 300
DECLARE @CGW0_TST   AS INT = 400
;
INSERT #CGW0 VALUES (@CGW0_CDC, 'TS Digital - Modello IVA', 1, 'TS010', 'https://app.teamsystemdigital.com/portale', Null, 0, 0, 1, 9, 0, 0);
INSERT #CGW0 VALUES (@CGW0_TST, 'TS Digital - Modello IVA (ambiente Test)', 1, 'TS010', 'https://apptest.teamsystemdigital.com/portale', Null, 0, 0, 1, 10, 0, 0);

INSERT #CGW1 VALUES (@CGW0_CDC+0, @CGW0_CDC, 'Autenticazione', 'Modello IVA','https://b2b-auth-service.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_CDC+1, @CGW0_CDC, 'Autenticazione a scadenza', 'Modello IVA','https://b2b-auth-service.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_CDC+2, @CGW0_CDC, 'Company registry', 'Modello IVA','https://registry-read.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_CDC+3, @CGW0_CDC, 'Verifica attivazione servizio', 'Modello IVA','https://b2b-services-subscription.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_CDC+4, @CGW0_CDC, 'Abilitazione servizio', 'Modello IVA','https://metering.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_CDC+20, @CGW0_CDC, 'Anno 2020', 'Modello IVA','https://fiscaliweb2020c.incloudts.com/rest',0);
INSERT #CGW1 VALUES (@CGW0_CDC+21, @CGW0_CDC, 'Anno 2021', 'Modello IVA','https://fiscaliweb2020c.incloudts.com/rest21',0);
INSERT #CGW1 VALUES (@CGW0_CDC+22, @CGW0_CDC, 'Anno 2022', 'Modello IVA','https://fiscaliwebc.incloudts.com/IVN22/rest',0);
INSERT #CGW1 VALUES (@CGW0_CDC+23, @CGW0_CDC, 'Anno 2023', 'Modello IVA','https://fiscaliwebc.incloudts.com/IVN23/rest',0);

INSERT #CGW1 VALUES (@CGW0_TST-0, @CGW0_TST, 'Autenticazione', 'Modello IVA (ambiente Test)','https://b2b-auth-service-test.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_TST+1, @CGW0_TST, 'Autenticazione a scadenza', 'Modello IVA (ambiente Test)','https://b2b-auth-service-test.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_TST+2, @CGW0_TST, 'Company registry', 'Modello IVA (ambiente Test)','https://registry-read-test.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_TST+3, @CGW0_TST, 'Verifica attivazione servizio', 'Modello IVA (ambiente Test)','https://b2b-services-subscription-test.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_TST+4, @CGW0_TST, 'Abilitazione servizio', 'Modello IVA (ambiente Test)','https://metering-test.agyo.io/api',0);
INSERT #CGW1 VALUES (@CGW0_TST+20, @CGW0_TST, 'Anno 2020', 'Modello IVA (ambiente Test)','https://fweb20devc.incloudts.com/rest',0);
INSERT #CGW1 VALUES (@CGW0_TST+21, @CGW0_TST, 'Anno 2021', 'Modello IVA (ambiente Test)','https://fweb20devc.incloudts.com/rest21',0);
INSERT #CGW1 VALUES (@CGW0_TST+22, @CGW0_TST, 'Anno 2022', 'Modello IVA (ambiente Test)','https://fiscaliwebdevc.incloudts.com/IVN22/rest',0);
INSERT #CGW1 VALUES (@CGW0_TST+23, @CGW0_TST, 'Anno 2023', 'Modello IVA (ambiente Test)','https://fiscaliwebdevc.incloudts.com/IVN23/rest',0);

MERGE INTO CGW0_WEBSERVER AS Target 
USING (SELECT * FROM #CGW0) AS Source 
   ON (Target.CGW0_CODICE = Source.CGW0_CODICE) 
WHEN MATCHED  AND Source.CGW0_FLGPERS = 0 THEN
    UPDATE SET Target.CGW0_DESCRIZIONE = Source.CGW0_DESCRIZIONE
             , Target.CGW0_FLGACCOUNTAZ = Source.CGW0_FLGACCOUNTAZ
             , Target.CGW0_IDSOFTWARE = Source.CGW0_IDSOFTWARE
             , Target.CGW0_URL = Source.CGW0_URL
             , Target.CGW0_IDAZIENDA = Source.CGW0_IDAZIENDA
             , Target.CGW0_FLGPERS = Source.CGW0_FLGPERS
             , Target.CGW0_FLGFIRMATARIO = Source.CGW0_FLGFIRMATARIO
             , Target.CGW0_INDMENUPARAM = Source.CGW0_INDMENUPARAM
             , Target.CGW0_ORD = Source.CGW0_ORD
             , Target.CGW0_PROTOCOLLO = Source.CGW0_PROTOCOLLO
             , Target.CGW0_PORTA = Source.CGW0_PORTA
WHEN NOT MATCHED THEN
    INSERT(  CGW0_CODICE
           , CGW0_DESCRIZIONE
           , CGW0_FLGACCOUNTAZ
           , CGW0_IDSOFTWARE
           , CGW0_URL
           , CGW0_IDAZIENDA
           , CGW0_FLGPERS
           , CGW0_FLGFIRMATARIO
           , CGW0_INDMENUPARAM
           , CGW0_ORD
           , CGW0_PROTOCOLLO
           , CGW0_PORTA
          ) 
    VALUES(  Source.CGW0_CODICE
           , Source.CGW0_DESCRIZIONE
           , Source.CGW0_FLGACCOUNTAZ
           , Source.CGW0_IDSOFTWARE
           , Source.CGW0_URL
           , Source.CGW0_IDAZIENDA
           , Source.CGW0_FLGPERS
           , Source.CGW0_FLGFIRMATARIO
           , Source.CGW0_INDMENUPARAM
           , Source.CGW0_ORD
           , Source.CGW0_PROTOCOLLO
           , Source.CGW0_PORTA
          )
;

MERGE INTO CGW1_WEBSERVICE AS Target 
USING (SELECT * FROM #CGW1) AS Source 
   ON (Target.CGW1_CODICE = Source.CGW1_CODICE AND Target.CGW1_CODICE_CGW0 = Source.CGW1_CODICE_CGW0) 
WHEN MATCHED THEN
    UPDATE SET Target.CGW1_CODICE      = Source.CGW1_CODICE
             , Target.CGW1_CODICE_CGW0 = Source.CGW1_CODICE_CGW0
             , Target.CGW1_DESCRIZIONE = Source.CGW1_DESCRIZIONE
             , Target.CGW1_DESCRTIPOWS = Source.CGW1_DESCRTIPOWS
             , Target.CGW1_URL         = Source.CGW1_URL
             , Target.CGW1_FLGPERS     = Source.CGW1_FLGPERS
WHEN NOT MATCHED THEN
    INSERT (  CGW1_CODICE
            , CGW1_CODICE_CGW0
            , CGW1_DESCRIZIONE
            , CGW1_DESCRTIPOWS
            , CGW1_URL
            , CGW1_FLGPERS
           )
    VALUES (  Source.CGW1_CODICE
            , Source.CGW1_CODICE_CGW0
            , Source.CGW1_DESCRIZIONE
            , Source.CGW1_DESCRTIPOWS
            , Source.CGW1_URL
            , Source.CGW1_FLGPERS
           )
;

IF OBJECT_ID(N'tempdb..#CGW0', N'U') IS NOT NULL
  DROP TABLE #CGW0
;
IF OBJECT_ID(N'tempdb..#CGW1', N'U') IS NOT NULL
    DROP TABLE #CGW1
;

IF NOT EXISTS(SELECT * FROM FW95_SETTINGS WITH(NOLOCK) WHERE FW95_CODICE = 'CONTESTOSERVIZIWEB')
    INSERT FW95_SETTINGS
        VALUES('CONTESTOSERVIZIWEB', 'Contesto servizi Web (0 = produzione / 1 = test)',0)
;
GO 
